/*
 * Decompiled with CFR 0.152.
 */
package com.quantumdata.fmteditor.report;

import com.quantumdata.fmteditor.fmt.CmdValue;
import java.io.File;

public class FmtTableEntry {
    private String m_path;
    private String m_name;
    private CmdValue[] m_values;

    public FmtTableEntry(String string, CmdValue[] cmdValueArray) {
        File file = new File(string);
        String string2 = file.getParent();
        this.m_path = string2 != null ? file.getParent().replace('\\', '/') : "";
        this.m_name = file.getName();
        this.m_values = cmdValueArray;
    }

    public FmtTableEntry(String string, String string2, CmdValue[] cmdValueArray) {
        this.m_path = string;
        this.m_name = string2;
        this.m_values = cmdValueArray;
    }

    public String path() {
        return this.m_path;
    }

    public String name() {
        return this.m_name;
    }

    public String fullName() {
        return this.m_path + "/" + this.m_name;
    }

    public String getValue(String string) {
        if (this.m_values == null) {
            return "";
        }
        for (CmdValue cmdValue : this.m_values) {
            if (!cmdValue.getName().equalsIgnoreCase(string)) continue;
            String string2 = "";
            switch (cmdValue.getType()) {
                case BOOL: {
                    if (cmdValue.getBool()) {
                        string2 = "+";
                        break;
                    }
                    string2 = "-";
                    break;
                }
                case DOUBLE: {
                    if (cmdValue.getName().equals("PRAT")) {
                        string2 = String.format("%1$.5f", cmdValue.getDouble() / 1000000.0);
                        break;
                    }
                    if (cmdValue.getName().equals("HRAT")) {
                        string2 = String.format("%1$.5f", cmdValue.getDouble() / 1000.0);
                        break;
                    }
                    string2 = cmdValue.get();
                    break;
                }
                case INT: {
                    string2 = cmdValue.isEnum() ? cmdValue.getEnumName() : cmdValue.get();
                }
            }
            return string2;
        }
        return "";
    }

    public CmdValue getValue(int n) {
        if (n >= this.m_values.length) {
            return null;
        }
        return this.m_values[n];
    }
}

